import types
from typing import Any, Callable, Iterable, List, Mapping, TypeVar

from . import futures

import asynq

_T = TypeVar("_T")

class AsyncTaskCancelledError(GeneratorExit): ...

class AsyncTaskResult(GeneratorExit):
    def __init__(self, result: Any) -> None: ...

class AsyncTask(futures.FutureBase[_T]):
    def __init__(
        self,
        generator: types.GeneratorType,
        fn: Callable[..., Any],
        args: Iterable[object],
        kwargs: Mapping[str, object],
    ) -> None: ...
    def can_continue(self) -> bool: ...
    def is_blocked(self) -> bool: ...
    def dump_perf_stats(self) -> None: ...
    def to_str(self) -> str: ...
    def collect_perf_stats(self) -> None: ...
    def traceback(self) -> List[str]: ...
    def dump(self, indent: int = ...) -> None: ...
