import threading
from typing import Any, Generic, List, Optional, Tuple, TypeVar

from . import futures

_T = TypeVar("_T", bound=BatchItemBase)

class BatchingError(Exception): ...
class BatchCancelledError(BatchingError): ...

class BatchBase(futures.FutureBase, Generic[_T]):
    items: List[_T]
    def __init__(self) -> None: ...
    def is_flushed(self) -> bool: ...
    def is_cancelled(self) -> bool: ...
    def is_empty(self) -> bool: ...
    def get_priority(self) -> Tuple[int, int]: ...
    def flush(self) -> None: ...
    def cancel(self, error: Optional[Exception] = ...) -> None: ...
    def dump(self, indent: int = ...) -> None: ...

class BatchItemBase(futures.FutureBase):
    batch: BatchBase
    index: int
    def __init__(self: _T, batch: BatchBase[_T]) -> None: ...

class DebugBatchItem(BatchItemBase):
    def __init__(self, batch_name: str = ..., result: Any = ...) -> None: ...

class DebugBatch(BatchBase):
    def __init__(self, name: str = ..., index: int = 0) -> None: ...

class LocalDebugBatchState(threading.local): ...

def sync(tag: str = ...) -> DebugBatchItem: ...
