import qcore
from typing import Any, Generic, TypeVar

from . import contexts

_T = TypeVar("_T")

class AsyncScopedValue(Generic[_T]):
    def __init__(self, default: _T) -> None: ...
    def get(self) -> _T: ...
    def set(self, value: _T) -> None: ...
    def override(self, value: _T) -> _AsyncScopedValueOverrideContext: ...
    def __call__(self) -> _T: ...

class _AsyncScopedValueOverrideContext(contexts.AsyncContext):
    def __init__(self, target: AsyncScopedValue[_T], value: _T) -> None: ...
    def resume(self) -> None: ...
    def pause(self) -> None: ...

class _AsyncPropertyOverrideContext(contexts.AsyncContext):
    def __init__(self, target: Any, property_name: str, value: Any) -> None: ...
    def resume(self) -> None: ...
    def pause(self) -> None: ...

async_override = _AsyncPropertyOverrideContext
