from sys import argv

from typing_machines.abstract_machines.turing_machine import TuringMachine, Transition, Direction
from typing_machines.app import encode, Algorithm

# Example Turing machine
# Recognizes palindromes over {a,b}.
tm: TuringMachine = TuringMachine("q0", "q8", [
    Transition("q0", "a", "q1", "c", Direction.RIGHT),
    Transition("q1", "a", "q2", "a", Direction.RIGHT),
    Transition("q1", "b", "q2", "b", Direction.RIGHT),
    Transition("q1", TuringMachine.BLANK, "q8", "c", Direction.RIGHT),
    Transition("q1", "c", "q8", "c", Direction.RIGHT),
    Transition("q2", "a", "q2", "a", Direction.RIGHT),
    Transition("q2", "b", "q2", "b", Direction.RIGHT),
    Transition("q2", TuringMachine.BLANK, "q3", "c", Direction.LEFT),
    Transition("q2", "c", "q3", "c", Direction.LEFT),
    Transition("q3", "a", "q4", "c", Direction.LEFT),
    Transition("q4", "a", "q4", "a", Direction.LEFT),
    Transition("q4", "b", "q4", "b", Direction.LEFT),
    Transition("q4", TuringMachine.BLANK, "q0", "c", Direction.RIGHT),
    Transition("q4", "c", "q0", "c", Direction.RIGHT),
    Transition("q0", "b", "q5", "c", Direction.RIGHT),
    Transition("q5", "a", "q6", "a", Direction.RIGHT),
    Transition("q5", "b", "q6", "b", Direction.RIGHT),
    Transition("q5", TuringMachine.BLANK, "q8", "c", Direction.RIGHT),
    Transition("q5", "c", "q8", "c", Direction.RIGHT),
    Transition("q6", "a", "q6", "a", Direction.RIGHT),
    Transition("q6", "b", "q6", "b", Direction.RIGHT),
    Transition("q6", TuringMachine.BLANK, "q7", "c", Direction.LEFT),
    Transition("q6", "c", "q7", "c", Direction.LEFT),
    Transition("q7", "b", "q4", "c", Direction.LEFT),
    Transition("q0", TuringMachine.BLANK, "q8", "c", Direction.RIGHT),
    Transition("q0", "c", "q8", "c", Direction.RIGHT),
])

if __name__ == "__main__":
    if len(argv) != 3:
        print("""Usage: python main.py [algorithm] [input]
                 Example: python main.py Grigore abbabba > tm.py""")
    print(encode(Algorithm[argv[1]], tm, argv[2]))
