# Demo Model
This directory contains steps for using a pre-trained model, specifically a script to apply it to a file with JavaScript/TypeScript code (readout.py). To use, call readout.py with one parameter (a text file containing your code). It will produce a CSV file containing the top 10 type predictions for every token (only identifiers will have real type predictions) with the corresponding probabilities. It will also write the code with all the most likely annotations to the command line, but see note under caveats (this is not immediately valid TypeScript!).

The models are currently hosted on Google Drive; simply download them from [here](https://drive.google.com/drive/folders/1zZyIkgHCTXMiqrKCsR77Z_u2UyijJq9w?usp=sharing) and store them in the current directory. They may migrate in the future (e.g. if Github finally raises its file size limits); if they are ever unavailable, please open an issue.

## Caveats
Please note, this is not the final model used in the paper; it is trained on the same dataset with similar parameters (but with slightly different vocabulary sizes, see tokens.vocab and types.vocab), so it should achieve similar results. The current model was trained for just three epochs for demonstration purposes.

Secondly, note that this script simply annotates every _identifier_ with a type; to properly use this to add type annotations to existing code, you should add annotations only on variable declarations, parameters and function declarations (for their return type, after the parameters) using the ": *TYPE*" syntax. To elaborate: we annotate every identifier because this accelerates training. In addition, DeepTyper is not particularly consistent in that it may annotate different occurrences of the same variable (e.g. when declared and used) with different types. No doubt future work will improve on this, but for now we emit the annotations at every location so inconsistencies are spotted more easily and those interest in annotating types have access to (and may reconcile) the various judgements.
