# Artifact Submission Template

Please answer the following questions concisely, either with bullet lists or
short paragraphs.

Title of the submitted paper:
_Do Machine Learning Models Produce TypeScript Types that Type Check?_

ECOOP submission number for the paper: 71

## Overview: What does the artifact comprise?

Please list for each distinct component of your artifact:

* what type of artifact (data, code, proof, etc.)
    - Data (benchmarks and results) and code

* in which format (e.g., CSV, source code, binary, etc.)
    - Benchmarks are source code (NPM packages)
    - Results are log files, source code (TypeScript), and CSV files
    - Code is Python, TypeScript, and R

* can be found in which location
    - Benchmarks: `data/full/`
    - Results: `data/results/`
        - Raw results: `data/results/*-out/`
        - CSV files summarizing the raw results: `data/results/csv/`
        - Figures and tables produced from the CSVs: `data/results/figures/`
    - Source code: `src/`

* Which badges do you claim for your artifact?
    - Functional + Reusable
    - Available

## For authors claiming a functional or reusable badge: What are claims about the artifact’s functionality to be evaluated by the committee?

Please provide explicit references that link processes, data, or conclusions in
the paper with the location of the supporting component in the artifact.

- We use the following mapping for datasets in the paper:
    - `top1k-typed-nodeps` → "DefinitelyTyped, no deps"
    - `top1k-typed-with-typed-deps` → "DefinitelyTyped, with deps"
    - `top1k-untyped-nodeps` → "Never typed, no deps"
    - `top1k-untyped-with-typed-deps` → "Never typed, with deps"
    - If the dataset has the `-es6` suffix, it was the result of applying the
      step in §3.1.

- Note: Figures 1-3 and 13-16 are not generated from the experiment data

- All other figures and tables can be generated from the CSVs
    - Running `make figures` will:
        - copy the CSVs from `data/results/csv/` to `data/full/csv/`
        - run the R script `src/R/figures.R`, which reads the files in
          `data/full/csv/` and outputs to `data/full/figures/`
    - The pre-generated tables and figures used in the paper are in
      `data/results/figures/`
    - For the rest of this section, look in `data/full/figures/` for the
      produced tables (`*.tex`) and figures (`*.pdf`)

- Abstract
    - The number of packages (513), percent of packages that type check (21%),
      and percent of files that type check (69%) are saved in `constants.tex`
      and generated by `figures.R` on lines 92, 174, and 258

- §4.1 Dataset
    - Performing the dataset construction described in §4.1 results in:
        - datasets saved in `data/full/original/`
        - dependency type declarations listed in `data/full/package.json`
        - dependency type declarations saved in `data/full/node_modules/`
        - ground truth type declarations saved in `data/full/groundtruth/`
    - Table 1: `dataset_summary.tex`, `figures.R:103`
    - Figure 4: `package_loc_cdf.pdf`, `figure.R:115`

- §4.2 Success Rate of Type Checking
    - Do Migrated Packages Type Check?
        - Table 2: `pkg_typechecks.tex`, `figures.R:158`
        - Figure 5: `pkg_typechecks.pdf`, `figures.R:197`
    - How Many Files are Error Free?
        - Table 3: `files_no_errors.tex`, `figures.R:242`
        - Figure 6: `files_no_errors.pdf`, `figures.R:281`
        - Figure 7: `errorfree_per_package.pdf`, `figures.R:322`
    - What Percentage of Type Annotations Are Trivial?
        - Figure 8: `errorfree_files_anys.pdf`, `figures.R:538`
    - Do Migrated Types Match Human-Written Types (When Available)?
        - Table 4: `accuracy.tex`, `figures.R:383`
        - Figure 9: `accuracy.pdf`, `figures.R:405`
    - How Many Errors Occur in Each Package?
        - Figure 10: `error_cdf.pdf`, `figures.R:439`

- §4.3 Error Analysis
    - Figure 11: `error_codes.pdf`, `figures.R:641`
    - Table 5: `error_codes.tex`, `figures.R:617`

- §4.4 ECMAScript Module Conversion
    - Table 6: `typecheck_comparison.tex`, `figures.R:692`
    - Table 7: `files_no_errors_comparison.tex`, `figures.R:741`
    - Table 8: `accuracy_comparison.tex`, `figures.R:810`
    - Figure 12: `typechecks_es6.pdf`, `figures.R:848`

## For authors claiming a reusable badge: What are the authors' claims about the artifact's reusability to be evaluated by the committee?

Please list any reuse scenarios that you envision for your artifact, i.e.,
state how the artifact can be reused or repurposed beyond its role in the
submitted paper.

- Migrating your own project
    1. Look at the example in `data/playground/original/demo/example-program/`.
       You can edit the files or add your own files to the `example-program/`
       directory.
    2. If you are using any dependencies, make sure you add the dependency type
       definitions to `data/playground/node_modules/`.
    3. Optional: run `make playground-es6` to convert the example program to use
       ES6 modules. This will create the directory
       `data/playground/original/demo/example-program-es6` with the converted
       program.
    4. Run `make playground` to run type annotation prediction and type weaving,
       using DeepTyper, LambdaNet, and InCoder. This step will not run type
       checking.
    5. View the resulting TypeScript in
       `data/playground/DeepTyper-out/demo/baseline/example-program/`,
       `data/playground/LambdaNet-out/demo/baseline/example-program/`, and
       `data/playground/InCoder-out/demo/baseline/example-program/`. If you ran
       the ES6 conversion, you should also view
       `data/playground/DeepTyper-out/demo/baseline/example-program-es6/`,
       `data/playground/LambdaNet-out/demo/baseline/example-program-es6/`, and
       `data/playground/InCoder-out/demo/baseline/example-program-es6/`.
        - For DeepTyper, you may see a `Library.warn` file that says
          `Searching for types failed on tokens: function Library`. This is
          acceptable: it means not all type annotations got woven in, but the
          rest succeeded.
    6. To compile the TypeScript:
        - `cd src/weaver && make shell` will drop you into a container with
          `tsc`, the TypeScript compiler, in your environment.
        - `cd /data/playground/DeepTyper-out/demo/baseline/example-program` will
          take you to where the directory is mounted.
        - `tsc *.ts` will compile the files. If it compiles, you can run
          `node main.js`. If you want to edit the files, you will have to
          exit the container.
        - Repeat for LambdaNet and InCoder.
        - The type prediction is not deterministic, and all results may fail to
          type check.
        - `exit` to exit the container.
    7. Run `make clean-playground` to remove the generated files. This will also
       remove `*.csv`, `*.ts`, `*.warn`, `*.err`, and `*.out` files in
       `data/playground/original/demo/example-program/`.

- Adding a new model
    1. Create a new directory for the type prediction model, e.g. `NewModel/`.
       Ensure that it runs, ideally within a container.
    2. If the model outputs TypeScript, continue to step 3. Otherwise, you will
       need to update `src/weaver/`:
       - Update `src/weaver/src/index.ts`; see lines 6-7, 10, 15, and 57-62 for
         how DeepTyper and LambdaNet are handled.
       - Create `src/weaver/src/newmodel.ts` to implement the logic for weaving
         type annotations into a JavaScript file. Refer to
         `src/weaver/src/deeptyper.ts` and `src/weaver/src/lambdanet.ts` as
         examples.
       - When you are finished, `cd src/weaver && make build` to rebuild the
         container.
    3. Update `src/migrate_dataset`:
       - Add the new model to `src/migrate_dataset/main.py`; see lines 15 and
         90-98. You will also need to update
         `src/migrate_dataset/type_inference/__init__.py`.
       - Add a new file for running the model, e.g.
         `src/migrate_dataset/type_inference/newmodel.py`. For examples, refer
         to the files in `src/migrate_dataset/type_inference/`. There is no
         standard interface: DeepTyper takes a single file as a command-line
         argument, LambdaNet reads a list of directories from standard input,
         and InCoder takes a list of directories as command-line inputs. Also,
         LambdaNet and InCoder have significant startup costs, so they are
         started once and polled for results.
    4. Update `Makefile`. See the target `full` for how the new model can be
       added to the loops.
    5. Update `src/summarize_results.py`; see lines 31-35.
    6. `src/R/figures.R` will need to be updated. The container can be rebuilt
       with `cd src/R && make build`.
    7. Adding a new model is a labor-intensive, manual task. Each implementation
       has its own interface and format, so each one needs a custom adapter.

- Adding a new dataset
    1. Create a new directory in `data/full/original/`, e.g.
       `data/full/original/new-dataset`.
    2. For each JavaScript project you want to add to the dataset, add it to
       `data/full/original/new-dataset`.
    3. If a project has `.d.ts` type declarations, add them to
       `data/full/groundtruth/`.
    4. Install the project dependencies' type declarations to
       `data/full/node_modules/`.
    5. `make full` does not need to be updated to handle the new dataset.
    6. `src/R/figures.R` will need to be updated. The container can be rebuilt
       with `cd src/R && make build`.
    7. Adding a new dataset is a labor-intensive, manual task. See §4.1 in the
       paper for how we did this. As part of that task, we wrote some scripts
       that were meant to be throwaway, but we include them in
       `src/dataset_tools/` for completeness. They are lightly documented, but
       have not been tested within this artifact.

## For authors claiming an available badge

We offer to publish the artifact on
[DARTS](https://drops.dagstuhl.de/opus/institut_darts.php), in which case the
available badge will be issued automatically. If you agree to publishing your
artifact under a Creative Commons license, please indicate this here.

- Yes

## Artifact Requirements

Please list any specific hardware or software requirements for accessing your
artifact.

- We are providing the reviewers with SSH access to a VM with the hardware and
  software already set up:
    - `ssh reviewer@[REDACTED]`
    - Password: `[REDACTED]`
    - The home directory is `/reviewerhome` and contains a copy of the artifact
      tarball
    - **Important**: Reviewers, please coordinate with each other to share
      access to the VM, to avoid clobbering files or consuming all resources
    - You can use the `reviewer1`, `reviewer2`, and `reviewer2` subdirectories
    - Nobody else will be using the VM
    - The VM has a 12-core Intel Xeon processor @ 2.9 GHz, 94 GB of RAM,
      and an NVIDIA A100 with 40 GB of VRAM; its disk performance is not great.

- To run on your own machine, you will need:
    - Hardware: a GPU with at least 14 GB of VRAM
        - It is possible to skip the experiments that require a GPU; see the
          README at the root of the repo.
    - Software:
        - Linux
        - Python +3.6 and the `tqdm` package (`pip install tqdm`)
        - [Podman](https://podman.io/) with the [NVIDIA container toolkit](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/install-guide.html#podman)
            - All other dependencies are managed with OCI images
            - Docker may be used instead of Podman, but has not been tested

## Getting Started

Please briefly describe how to get started with your artifact.

- If you are using the VM:
    1. `ssh reviewer@[REDACTED]` with password `[REDACTED]`. `cd` into one of
       the reviewer subdirectories, and extract the tarball with
       `tar xf ../TypeWeaver-artifact.tar.gz`.
    2. Run `make build` to build the containers. The containers on the VM are
       pre-built, so it should only take a few minutes.
    3. Run `make micro` to run the evaluation pipeline on a single project.
       This should take 5 minutes, and checks that all the containers are
       working.
        - Inspect the DeepTyper and LambdaNet results by running
          `less data/micro/DeepTyper-out/top1k-typed-nodeps-es6/baseline/decamelize/index.ts`
          and
          `less data/micro/LambdaNet-out/top1k-typed-nodeps-es6/baseline/decamelize/index.ts`.
          InCoder is not expected to produce a result. Compare to the original
          JavaScript source by running
          `less data/micro/original/top1k-typed-nodeps-es6/decamelize/index.js`
    4. Recreate the tables and figures by running `make figures`. This will
       create `data/full/figures/` and take a few seconds.
        - Compare the generated figures (`data/full/figures/`) with the figures
          used in the paper (`results/figures/`), by running
          `diff data/full/figures/ data/results/figures/`. The tables should
          match exactly. The PDFs should match visually, but are not binary
          matches.

- If you are using your own machine:
    1. Download and extract the tarball with `tar xf TypeWeaver-artifact.tar.gz`.
    2. Run `make build` to build the containers. This may take up to an hour and
       use up to 30 GB of space.
    3. Run `make micro` (or `make NOGPU=true micro` if you do not have a GPU).
       This should take 5 minutes, and checks that all the containers are
       working.
        - Inspect the DeepTyper and LambdaNet results by running
          `less data/micro/DeepTyper-out/top1k-typed-nodeps-es6/baseline/decamelize/index.ts`
          and
          `less data/micro/LambdaNet-out/top1k-typed-nodeps-es6/baseline/decamelize/index.ts`.
          InCoder is not expected to produce a result. Compare to the original
          JavaScript source by running
          `less data/micro/original/top1k-typed-nodeps-es6/decamelize/index.js`
    4. Recreate the tables and figures by running `make figures`. This will
       create `data/full/figures/` and take a few seconds.
        - Compare the generated figures (`data/full/figures/`) with the figures
          used in the paper (`results/figures/`), by running
          `diff data/full/figures/ data/results/figures/`. The tables should
          match exactly. The PDFs should match visually, but are not binary
          matches.

We estimate that running the full experiments on the provided VM will take over
30 hours. Please see the README at the repository root for instructions on
running the experiments, as well as how to skip stages of the experiment.
