import assert from 'assert';

export default function (input, copy) {
	assert.deepStrictEqual(copy, input, 'initial copy');

	// RegExp
	copy.regexp.lastIndex = 9;
	assert.notEqual(input.regexp.lastIndex, 9, 'regexp.lastindex');

	// Array + Date
	input.array[0].setMinutes(1);
	assert.notEqual(copy.array[0].getMinutes(), 0, 'Array<Date> #1');

	copy.array[3] = new Date(copy.array[3]);
	assert.notEqual(input.array[3] instanceof Date, true, 'Array<Date> #2');

	// Set
	input.set.add(9);
	assert.equal(copy.set.has(9), false, 'Set #1');

	[...copy.set][2].push(123);
	assert.deepEqual([...input.set][2], [1, 2, 3], 'Set #2');
	assert.deepEqual([...copy.set][2], [1, 2, 3, 123], 'Set #3');

	// Map
	input.map.set('hello', 'world');
	assert.equal(copy.map.has('hello'), false, 'Map #1');

	[...copy.map.keys()][0].bar = 123;
	assert.deepEqual([...input.map.keys()][0], { foo: 1 }, 'Map #2');
	assert.deepEqual([...copy.map.keys()][0], { foo: 1, bar: 123 }, 'Map #3');

	// Class
	input.custom.value = 789;
	assert.equal(copy.custom.number, 456, 'Class #1');

	input.custom.items.push(789);
	assert.deepEqual(copy.custom.items, [1, 2, 3], 'Class #2');

	copy.custom.items.pop();
	assert.equal(input.custom.items.length, 4, 'Class #3');

	// Int8Array
	copy.int8arr[1] = 42;
	assert.equal(input.int8arr[1], 5, 'Int8 #1');

	input.int8arr[0] = 0;
	assert.equal(copy.int8arr[0], 4, 'Int8 #2');

	// Buffer :: "hello"
	copy.buffer.write('foobar');
	assert.equal(input.buffer.toString(), 'hello', 'Buffer #1');

	copy.buffer[1] = 11;
	assert.notEqual(input.buffer[1], copy.buffer[1], 'Buffer #2');

	const current = copy.buffer.toString();
	input.buffer.write('hello');
	assert.equal(copy.buffer.toString(), current, 'Buffer #3');

	// DataView :: [0, 0, 0]
	input.dataview.setInt8(1, 1);
	assert.equal(input.dataview.getInt8(1), 1, 'Dataview #1');
	assert.equal(copy.dataview.getInt8(1), 0, 'Dataview #2');

	copy.dataview.setInt8(0, 3);
	assert.equal(input.dataview.getInt8(0), 0, 'Dataview #3');
	assert.equal(copy.dataview.getInt8(0), 3, 'Dataview #4');
};
