## Prerequisites

Requires [Node.js](https://nodejs.org/en/) version >= 14.

## Usage

```js
import pascalcase from '{%= name %}';
// or the following if you prefer
import { pascalcase } from '{%= name %}';

console.log(pascalcase('a')); //=> 'A'
console.log(pascalcase('foo bar baz')); //=> 'FooBarBaz'
console.log(pascalcase('  foo bar baz  ')); //=> 'FooBarBaz'
console.log(pascalcase('foo_bar-baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo.bar.baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo/bar/baz')); //=> 'FooBarBaz'
console.log(pascalcase('foo[bar)baz')); //=> 'FooBarBaz'
console.log(pascalcase('#foo+bar*baz')); //=> 'FooBarBaz'
console.log(pascalcase('$foo~bar`baz')); //=> 'FooBarBaz'
console.log(pascalcase('_foo_bar-baz-')); //=> 'FooBarBaz'
console.log(pascalcase('foo 2 bar 5 baz')); //=> 'Foo2Bar5Baz'
console.log(pascalcase('foo2bar5baz')); //=> 'Foo2bar5baz'
```

## Uppercase character sequences

If you wish to preserve upper case character sequences, you may pass an options object with the `preserveConsecutiveUppercase` option set to `true`:

```js
console.log(pascalcase('The IRS Is Mean')); //=> 'TheIrsIsMean
console.log(pascalcase('The IRS Is Mean', { preserveConsecutiveUppercase: true })); //=> TheIRSIsMean

console.log(pascalcase('We saw a UFO')); //=> WeSawAUfo
console.log(pascalcase('We saw a UFO', { preserveConsecutiveUppercase: true })); //=> WeSawAUFO
```

## Options

All options are passed to [sindresorhus/camelcase](https://github.com/sindresorhus/camelcase), please visit that project to learn about all available options.
