## About

> A symbol is a unique and immutable data type and may be used as an identifier for object properties. The symbol object is an implicit object wrapper for the symbol primitive data type. - [Mozilla Developer docs for Symbol](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Symbol)

## Usage

```js
const assignSymbols = require('{%= name %}');
let target = {};

// add a symbol to object "one"
let one = {};
let symbolOne = Symbol('aaa');
one[symbolOne] = 'bbb';

// add a symbol to object "two"
let two = {};
let symbolTwo = Symbol('ccc');
two[symbolTwo] = 'ddd';

// assign symbols from objects "one" and "two" to object "target"
assignSymbols(target, one, two);

console.log(target[symbolOne]); //=> 'bbb'
console.log(target[symbolTwo]); //=> 'ddd'
```
