let globalPnpApi: any;
try {
    globalPnpApi = require(`pnpapi`);
} catch {
    // Just ignore if we don't have a global PnP instance - perhaps
    // we'll eventually find one at runtime due to multi-tree
}

const createRequire: any = require(`./createRequire`);
const getDefaultResolver: any = require(`./getDefaultResolver`);

export default (request: any, options: any) => {
  const {basedir, defaultResolver, extensions} = options;

  if (process.versions.pnp) {
    let pnpApi: any = globalPnpApi;

    // While technically it would be more correct to run this code
    // everytime (since they file being run *may* belong to a
    // different dependency tree than the one owning Jest), in
    // practice this doesn't happen anywhere else than on the Jest
    // repository itself (in the test env). So in order to preserve
    // the performances, we can afford a slight incoherence here.
    if (!pnpApi) {
      try {
        const baseReq: any = createRequire(`${basedir}/internal.js`);
        pnpApi = baseReq(`pnpapi`);
      } catch {
        // The file isn't part of a PnP dependency tree, so we can
        // just use the default Jest resolver.
      }
    }

    if (pnpApi) {
      const resolution: any = pnpApi.resolveRequest(request, `${basedir}/`, {extensions});

      // When the request is a native module, Jest expects to get the string back unmodified, but pnp returns null instead.
      if (resolution === null)
        return request;

      return resolution;
    }
  }

  if (!defaultResolver)
    defaultResolver = getDefaultResolver();

  return defaultResolver(request, {...options, allowPnp: false});
};
