# Overview
This artifact for the ECOOP submission, Semantics for Noninterence with Interaction Trees, submission #6, is a Coq library containing formalized versions of all definitions and proofs contained in the paper. We have included the source code, relevant build scripts, as well as a Docker image (to quickly verify that the code builds without needing to install dependencies).

# Core Claims
We claim this artifact deserves the reusable badge (and therefore functional and available as well).
This document provides a mapping from definitions and proofs in the paper to formalized versions in the artifact.

## Potential Reuse Scenario
A research team could replicate the work we did for the example Imp with security labels for another language with some notion of noninterference.

In particular, a research team could develop semantics for a programming language using Interaction Trees, create a type system for noninterference, and prove the soundness of that type system with respect to the Interaction Trees semantics.

They could also develop a compiler between two such languages and prove that the compiler preserves noninterference.

## Usage Guide
The primary tools provided by this library are the progress sensitive and progress insensitive indistinguishability relations, `eqit_secure` and `pi_eqit_secure` respectively.
In order use these indistinguishability relations to compare two ITrees, of types `itree E R1` and `itree E R2`, you need to provide several parameters:
- a `Preorder`, a typeclass defined in `theories/Secure/SecureEqHalt.v` at line 47, that defines a type of labels, `L`, and a `leq` relation over those labels
- a `priv` function, of type `forall A, E A -> L`, which decides the privilege level of each event (for example, this function could assign variable access events a privilege level based on the particular variable they access)
- a particular privilege level `l`, which determines the privilege level of a particular observer whose view this relation represents
- two boolean values `b1` and `b2` which determine whether silent actions, either `Tau` steps or `Vis` nodes with events that are too private for the observer at level `l` to be allowed to view, can be inductively ignored (for all of the examples in the paper, both of these values are set to `true`)
- a relation `RR` over `R1` and `R2` which represents the observer's view of the return values of computations

With all of these pieces in place, `eqit_secure Label RR priv b1 b2 l` is the resulting progress sensitive indistinguishability relation, while `pi_eqit_secure Label RR priv b1 b2 l` is the resulting progress insensitive indistinguishability relation.

To see an example of how we can set those parameters to compare the semantics of Imp programs, please see `label_eqit_secure_impstate` at `secure_example/LabelledImpInlineTypes.v` at line 77, or `label_pi_eqit_secure_impstate` at `secure_example/LabelledImpImlineTypesProgInsens.v` at line 69.

# Getting Started
## Docker
We have provided a docker image to verify that the code runs without needing to install dependencies on your machine. To run it, first load the image with `docker load -i secure.tar`, and then run it with `docker run itrees/secure:latest`
## Dependencies
- coq >= 15.2
- coq-paco >= 4.1.2
- coq-ext-lib >= 0.11.7
## Build
To build just the core Interaction Trees library with secure bisimulation tools, run `make`.

To build both the core library and the examples discussed in the paper, run `make secure_artifact`.

Please consult `Dev.md` for more information about navigating the library.
# Core Secure ITrees Library
## Definitions Table
- `paper_name` -> `repo_name` at `filpath:line#`
    - Notes
- `itree` -> `itree` at `theories/Core/ITreeDefinition.v:24-58`
    - `itree` is defined by taking the greatest fixed point of a negatively defined type operator, `itreeF`
    - The `τ` constructor in the paper corresponds to `Tau` in the code
- `trigger` -> `trigger` at `theories/Core/ITreeDefinition.v:210`
- `iter` -> `iter` at `theories/Core/ITreeDefinition.v:193`
- Imp Commands -> `stmt` at `secure_example/LabelledImp.v:53`
- ASM program -> `asm` at `secure_example/LabelledAsm.v:163`
- Imp denote function -> `denote_stmt` at `secure_example/LabelledImp.v:99`
- weak bisimulation -> `eutt` at `theories/Eq.Eq.v` 
    - `eutt` is defined in terms of the more general `eqit` relation, that provides parameters to control whether `Tau`'s can be ignored
- h_{exc} -> `hexc` at `theories/Events/Exception.v:146`
- `trycatch` -> `try_catch` at `theories/Events/Exception.v:58`
    - In the code, `try_catch` is defined in terms of the `iter` combinator rather than interpretation. The version shown in the paper is justified to be equivalent by the lemma `throw_prefix_interp` at `theories/Events/ExceptionFacts.v`
- Progress Sensitive Indistinguishability -> `eqit_secure` at `theories/Secure/SecureEqHalt.v:55-124`
- Progress Insensitive Indistiguishability -> `pi_eqit_secure` at `theories/SecureEqProgInsens.v:39-107`
- Definition 19 stateful indistinguishability -> `state_eqit_secure` at `theories/Secure/SecureStateHandler.v:66` and `state_pi_eqit_secure` at `theories/Secure/SecureStateHandlerPi.v:56`
- Type System -> `well_typed_stmt` at `secure_example/LabelledImpInlineTypes.v:987` and `well_typed_stmt` at `secure_example/LabelledImpTypesProgInsens.v:987`
- Definitions 21/22 -> `secure_throw_stmt` at `secure_example/LabelledImpTypes.v:144` and `secure_throw_stmt` at `secure_example/LabelledImpTypesProgInsens.v:156`
- Definition 24 Inline Validity -> `valid_asm` at `secure_example/LabelledImpInline2AsmCorrectness.v:896`
- Definition 25 Validity -> `valid_stmt` at `secure_example/LabelledImpInline2AsmCorrectness.v:901`
## Theorems/Lemmas Table
- Lemma 1 -> `eqit_vis` at `theories/Eq/Eq.v:1008`
- Theorem 2 -> `try_catch_ret`, `try_catch_tau`, `try_catch_exc`, and `try_catch_ev` at `theories/Events/Exception.v:89-120`
- Theorem 3 -> `eqit_secure_imp_pi_eqit_scure` at `theories/Secure/SecureEqHalt.v:220`
- Theorem 4 -> `eqit_secure_trans` at `theories/Secure/SecureEqEuttHalt.v:653`
- Theorem 6 -> `secure_eqit_bind` at `theories/SecureEqBind.v:144`
- Theorem 7 -> `secure_eqit_iter` at `theories/Secure/SecureEqBind.v:264`
- Theorem 8 -> `eutt_secure_eqit_secure` at `theories/Secure/SecureEqEuttTrans.v:100`
- Theorem 10 -> `pi_eqit_secure_sym` at `theories/Secure/SecureEqProgInsens.v:149`
- Theorem 11 -> `pi_eqit_secure_spin` at `theories/Secure/SecureEqProgInsens.v:173`
- Theorem 12 -> `pi_eqit_secure_private_halt` at `theories/Secure/SecureEqProgInsens.v:179`
- Theorem 13 -> `pi_eqit_secure_bind` at `theories/Secure/SecureEqProgInsens.v:401`
- Theorem 14 -> `secure_eqit_iter` at `theories/Secure/SecureEqProgInsens.v:490`
- Theorem 15 -> `pi_eqit_secure_mixed_trans` at `theories/Secure/SecureEqProgInsensFacts.v`
- Theorem 16 -> `pi_eqit_secure_sym` at `theories/Secure/SecureEqProgInsens.v:149`
- Theorem 17 -> `pi_eqit_secure_trans_term` at `theories/Secure/SecureEqProgInsensFacts.v:178`
- Theorem 18 -> `pi_eqit_secure_trans_ret` at `theories/Secure/SecureEqProgInsensFacts.v:156`
- Theorem 23 -> `well_typed_stmt_sound` at `theories/Secure/LabelledImpInlineTypes.v` and `well_typed_stmt_sound` at `theories/LabelledImpInlineTypesProgInsens.v:1017`
- Theorem 26 -> `compile_correct` at `secure_example/LabelledImpInline2AsmCorrectness.v:1508`
- Theorem 27 -> `compile_preserves_ps_security` at `secure_example/LabelledImpInline2AsmNoninterferencePres.v:72` and `compile_preserves_pi_security` at `secure_example/LabelledImpInline2AsmNoninterferencePres.v:140`
- Theorem 28 -> `compile_preserves_ps_ni` at `secure_example/LabelledImpInline2AsmNoninterferencePres.v:91` and `compile_preserves_pi_in` at `secure_example/LabelledImpInline2AsmNoninterferencePres.v:159`
