
type __ = Obj.t
let __ = let rec f _ = Obj.repr f in Obj.repr f

(** val negb : bool -> bool **)

let negb = function
| true -> false
| false -> true

(** val option_map : ('a1 -> 'a2) -> 'a1 option -> 'a2 option **)

let option_map f = function
| Some a -> Some (f a)
| None -> None

type ('a, 'b) sum =
| Inl of 'a
| Inr of 'b

(** val fst : ('a1 * 'a2) -> 'a1 **)

let fst = function
| (x, _) -> x

(** val snd : ('a1 * 'a2) -> 'a2 **)

let snd = function
| (_, y) -> y



(** val add : int -> int -> int **)

let rec add = (+)

(** val mul : int -> int -> int **)

let rec mul = ( * )

(** val sub : int -> int -> int **)

let rec sub = fun n m -> Pervasives.max 0 (n-m)

type 'f functor0 =
  __ -> __ -> (__ -> __) -> 'f -> 'f
  (* singleton inductive, whose constructor was Build_Functor *)

(** val fmap : 'a1 functor0 -> ('a2 -> 'a3) -> 'a1 -> 'a1 **)

let fmap functor1 x x0 =
  Obj.magic functor1 __ __ x x0

type 'm monad = { ret : (__ -> __ -> 'm);
                  bind : (__ -> __ -> 'm -> (__ -> 'm) -> 'm) }

(** val ret : 'a1 monad -> 'a2 -> 'a1 **)

let ret monad0 x =
  Obj.magic monad0.ret __ x

(** val bind : 'a1 monad -> 'a1 -> ('a2 -> 'a1) -> 'a1 **)

let bind monad0 x x0 =
  Obj.magic monad0.bind __ __ x x0

module Monads =
 struct
  type ('s, 'm, 'a) stateT = 's -> 'm

  (** val coq_Functor_stateT :
      'a1 functor0 -> ('a2, 'a1, __) stateT functor0 **)

  let coq_Functor_stateT fm _ _ f run0 s =
    fmap fm (fun sa -> ((fst sa), (f (snd sa)))) (run0 s)

  (** val coq_Monad_stateT : 'a1 monad -> ('a2, 'a1, __) stateT monad **)

  let coq_Monad_stateT fm =
    { ret = (fun _ a s -> ret fm (s, a)); bind = (fun _ _ t k s ->
      bind fm (t s) (fun sa -> k (snd sa) (fst sa))) }
 end

type 'm monadIter = __ -> __ -> (__ -> 'm) -> __ -> 'm

(** val iter : 'a1 monadIter -> ('a3 -> 'a1) -> 'a3 -> 'a1 **)

let iter monadIter0 x x0 =
  Obj.magic monadIter0 __ __ x x0

(** val monadIter_stateT0 :
    'a1 monad -> 'a1 monadIter -> ('a4 -> ('a2, 'a1, ('a4, 'a3) sum)
    Monads.stateT) -> 'a4 -> ('a2, 'a1, 'a3) Monads.stateT **)

let monadIter_stateT0 mM aM step i s =
  iter aM (fun si ->
    let s0 = fst si in
    let i0 = snd si in
    bind mM (step i0 s0) (fun si' ->
      ret mM
        (match snd si' with
         | Inl i' -> Inl ((fst si'), i')
         | Inr r -> Inr ((fst si'), r)))) (s, i)

type ('obj, 'c) id_ = 'obj -> 'c

(** val id_0 : ('a1, 'a2) id_ -> 'a1 -> 'a2 **)

let id_0 id_1 =
  id_1

type ('obj, 'c) cat = 'obj -> 'obj -> 'obj -> 'c -> 'c -> 'c

(** val cat0 : ('a1, 'a2) cat -> 'a1 -> 'a1 -> 'a1 -> 'a2 -> 'a2 -> 'a2 **)

let cat0 cat1 =
  cat1

type ('obj, 'c) bimap = 'obj -> 'obj -> 'obj -> 'obj -> 'c -> 'c -> 'c

(** val bimap0 :
    ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) bimap -> 'a1 -> 'a1 -> 'a1 -> 'a1 ->
    'a2 -> 'a2 -> 'a2 **)

let bimap0 _ bimap1 =
  bimap1

type ('obj, 'c) case = 'obj -> 'obj -> 'obj -> 'c -> 'c -> 'c

(** val case_ :
    ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) case -> 'a1 -> 'a1 -> 'a1 -> 'a2 -> 'a2
    -> 'a2 **)

let case_ _ case0 =
  case0

type ('obj, 'c) inl = 'obj -> 'obj -> 'c

(** val inl_ : ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) inl -> 'a1 -> 'a1 -> 'a2 **)

let inl_ _ inl0 =
  inl0

type ('obj, 'c) inr = 'obj -> 'obj -> 'c

(** val inr_ : ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) inr -> 'a1 -> 'a1 -> 'a2 **)

let inr_ _ inr0 =
  inr0

(** val bimap_Coproduct :
    ('a1, 'a2) cat -> ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) case -> ('a1, 'a2)
    inl -> ('a1, 'a2) inr -> ('a1, 'a2) bimap **)

let bimap_Coproduct cat_C sUM coprod_SUM inl_SUM inr_SUM a b c d f g =
  case_ sUM coprod_SUM a b (sUM c d)
    (cat0 cat_C a c (sUM c d) f (inl_ sUM inl_SUM c d))
    (cat0 cat_C b d (sUM c d) g (inr_ sUM inr_SUM c d))

type ('obj, 'c) iter0 = 'obj -> 'obj -> 'c -> 'c

(** val iter1 :
    ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) iter0 -> 'a1 -> 'a1 -> 'a2 -> 'a2 **)

let iter1 _ iter2 =
  iter2

type ('obj, 'c) reSum = 'c

(** val resum : 'a1 -> 'a1 -> ('a1, 'a2) reSum -> 'a2 **)

let resum _ _ reSum0 =
  reSum0

(** val reSum_id : ('a1, 'a2) id_ -> 'a1 -> ('a1, 'a2) reSum **)

let reSum_id =
  id_0

(** val reSum_inl :
    ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) cat -> ('a1, 'a2) inl -> 'a1 -> 'a1 ->
    'a1 -> ('a1, 'a2) reSum -> ('a1, 'a2) reSum **)

let reSum_inl bif h0 h2 a b c h4 =
  cat0 h0 a b (bif b c) (resum a b h4) (inl_ bif h2 b c)

type ('e, 'r, 'itree) itreeF =
| RetF of 'r
| TauF of 'itree
| VisF of 'e * (__ -> 'itree)

type ('e, 'r) itree = ('e, 'r) __itree Lazy.t
and ('e, 'r) __itree =
| Go of ('e, 'r, ('e, 'r) itree) itreeF

(** val _observe : ('a1, 'a2) itree -> ('a1, 'a2, ('a1, 'a2) itree) itreeF **)

let _observe i =
  let Go _observe0 = Lazy.force i in _observe0

(** val observe : ('a1, 'a2) itree -> ('a1, 'a2, ('a1, 'a2) itree) itreeF **)

let observe =
  _observe

module ITree =
 struct
  (** val subst :
      ('a2 -> ('a1, 'a3) itree) -> ('a1, 'a2) itree -> ('a1, 'a3) itree **)

  let rec subst k u =
    match observe u with
    | RetF r -> k r
    | TauF t -> lazy (Go (TauF (subst k t)))
    | VisF (e, h) -> lazy (Go (VisF (e, (fun x -> subst k (h x)))))

  (** val bind :
      ('a1, 'a2) itree -> ('a2 -> ('a1, 'a3) itree) -> ('a1, 'a3) itree **)

  let bind u k =
    subst k u

  (** val iter :
      ('a3 -> ('a1, ('a3, 'a2) sum) itree) -> 'a3 -> ('a1, 'a2) itree **)

  let rec iter step i =
    bind (step i) (fun lr ->
      match lr with
      | Inl l -> lazy (Go (TauF (iter step l)))
      | Inr r -> lazy (Go (RetF r)))

  (** val map : ('a2 -> 'a3) -> ('a1, 'a2) itree -> ('a1, 'a3) itree **)

  let map f t =
    bind t (fun x -> lazy (Go (RetF (f x))))

  (** val trigger : 'a1 -> ('a1, 'a2) itree **)

  let trigger e =
    lazy (Go (VisF (e, (fun x -> lazy (Go (RetF (Obj.magic x)))))))
 end

(** val functor_itree : ('a1, __) itree functor0 **)

let functor_itree _ _ =
  ITree.map

(** val monad_itree : ('a1, __) itree monad **)

let monad_itree =
  { ret = (fun _ x -> lazy (Go (RetF x))); bind = (fun _ _ -> ITree.bind) }

(** val monadIter_itree :
    ('a3 -> ('a1, ('a3, 'a2) sum) itree) -> 'a3 -> ('a1, 'a2) itree **)

let monadIter_itree =
  ITree.iter

type ('m, 'a, 'b) kleisli = 'a -> 'm

(** val iter_Kleisli :
    'a1 monadIter -> ('a1, 'a2, ('a2, 'a3) sum) kleisli -> ('a1, 'a2, 'a3)
    kleisli **)

let iter_Kleisli =
  iter

module Nat =
 struct
 end

type ('e1, 'e2, 'x) sum1 =
| Inl1 of 'e1
| Inr1 of 'e2

type ('e, 'f) iFun = __ -> 'e -> 'f

(** val id_IFun : 'a1 -> 'a1 **)

let id_IFun e =
  e

(** val cat_IFun : ('a1, 'a2) iFun -> ('a2, 'a3) iFun -> 'a1 -> 'a3 **)

let cat_IFun f1 f2 e =
  f2 __ (f1 __ e)

(** val case_sum1 :
    (__ -> 'a1 -> 'a3) -> (__ -> 'a2 -> 'a3) -> ('a1, 'a2, 'a4) sum1 -> 'a3 **)

let case_sum1 f g = function
| Inl1 a -> f __ a
| Inr1 b -> g __ b

(** val case_sum0 :
    ('a1, 'a3) iFun -> ('a2, 'a3) iFun -> ('a1, 'a2, 'a4) sum1 -> 'a3 **)

let case_sum0 =
  case_sum1

(** val inl_sum1 : 'a1 -> ('a1, 'a2, 'a3) sum1 **)

let inl_sum1 x =
  Inl1 x

(** val subevent : ('a1, 'a2) iFun -> 'a1 -> 'a2 **)

let subevent h x =
  resum __ __ h __ x

type ('u, 'v) embeddable = 'u -> 'v

(** val embed : ('a1, 'a2) embeddable -> 'a1 -> 'a2 **)

let embed embeddable0 =
  embeddable0

(** val embeddable_forall :
    ('a1 -> ('a2, 'a3) embeddable) -> ('a1 -> 'a2, 'a1 -> 'a3) embeddable **)

let embeddable_forall h u a =
  embed (h a) (u a)

(** val embeddable_itree :
    ('a1, 'a2) iFun -> ('a1, ('a2, 'a3) itree) embeddable **)

let embeddable_itree h e =
  ITree.trigger (subevent h e)

(** val interp :
    'a2 functor0 -> 'a2 monad -> 'a2 monadIter -> (__ -> 'a1 -> 'a2) -> ('a1,
    'a3) itree -> 'a2 **)

let interp fM mM iM h =
  iter iM (fun t ->
    match observe t with
    | RetF r -> ret mM (Inr r)
    | TauF t0 -> ret mM (Inl t0)
    | VisF (e, k) -> fmap fM (fun x -> Inl (k x)) (h __ e))

module Handler =
 struct
  (** val htrigger : (__ -> 'a1 -> 'a2) -> 'a1 -> ('a2, 'a3) itree **)

  let htrigger m e =
    ITree.trigger (m __ e)

  (** val id_ : 'a1 -> ('a1, 'a2) itree **)

  let id_ =
    ITree.trigger

  (** val cat :
      (__ -> 'a1 -> ('a2, __) itree) -> (__ -> 'a2 -> ('a3, __) itree) -> 'a1
      -> ('a3, 'a4) itree **)

  let cat f g e =
    interp (Obj.magic functor_itree) (Obj.magic monad_itree)
      (Obj.magic (fun _ _ -> monadIter_itree)) (Obj.magic g) (f __ e)

  (** val inl_ : 'a1 -> (('a1, 'a2, __) sum1, 'a3) itree **)

  let inl_ x =
    htrigger (Obj.magic (fun _ x0 -> Inl1 x0)) x

  (** val inr_ : 'a2 -> (('a1, 'a2, __) sum1, 'a3) itree **)

  let inr_ x =
    htrigger (Obj.magic (fun _ x0 -> Inr1 x0)) x

  (** val case_ :
      (__ -> 'a1 -> ('a3, __) itree) -> (__ -> 'a2 -> ('a3, __) itree) ->
      ('a1, 'a2, 'a4) sum1 -> ('a3, 'a4) itree **)

  let case_ f g = function
  | Inl1 a -> Obj.magic f __ a
  | Inr1 b -> Obj.magic g __ b
 end

type ('e, 'f) handler = __ -> 'e -> ('f, __) itree

(** val id_Handler : 'a1 -> ('a1, 'a2) itree **)

let id_Handler =
  Handler.id_

(** val cat_Handler :
    ('a1, 'a2) handler -> ('a2, 'a3) handler -> 'a1 -> ('a3, 'a4) itree **)

let cat_Handler =
  Handler.cat

(** val case_sum1_Handler :
    ('a1, 'a3) handler -> ('a2, 'a3) handler -> ('a1, 'a2, 'a4) sum1 -> ('a3,
    'a4) itree **)

let case_sum1_Handler =
  Handler.case_

(** val inl_sum1_Handler : 'a1 -> (('a1, 'a2, __) sum1, 'a3) itree **)

let inl_sum1_Handler =
  Handler.inl_

(** val inr_sum1_Handler : 'a2 -> (('a1, 'a2, __) sum1, 'a3) itree **)

let inr_sum1_Handler =
  Handler.inr_

(** val filter : ('a1 -> bool) -> 'a1 list -> 'a1 list **)

let rec filter f = function
| [] -> []
| x :: l0 -> if f x then x :: (filter f l0) else filter f l0

type positive =
| XI of positive
| XO of positive
| XH

type n =
| N0
| Npos of positive

module Pos =
 struct
  (** val iter_op : ('a1 -> 'a1 -> 'a1) -> positive -> 'a1 -> 'a1 **)

  let rec iter_op op p a =
    match p with
    | XI p0 -> op a (iter_op op p0 (op a a))
    | XO p0 -> iter_op op p0 (op a a)
    | XH -> a

  (** val to_nat : positive -> int **)

  let to_nat x =
    iter_op add x (Pervasives.succ 0)
 end

module N =
 struct
  (** val to_nat : n -> int **)

  let to_nat = function
  | N0 -> 0
  | Npos p -> Pos.to_nat p
 end

type 't relDec =
  't -> 't -> bool
  (* singleton inductive, whose constructor was Build_RelDec *)

(** val rel_dec : 'a1 relDec -> 'a1 -> 'a1 -> bool **)

let rel_dec relDec0 =
  relDec0

(** val string_dec : char list -> char list -> bool **)

let rec string_dec l r =
  match l with
  | [] -> (match r with
           | [] -> true
           | _::_ -> false)
  | l0::ls ->
    (match r with
     | [] -> false
     | r0::rs -> if (=) l0 r0 then string_dec ls rs else false)

type ('k, 'v, 'map) map0 = { empty : 'map; add0 : ('k -> 'v -> 'map -> 'map);
                             remove : ('k -> 'map -> 'map);
                             lookup : ('k -> 'map -> 'v option);
                             union : ('map -> 'map -> 'map) }

(** val interp_state :
    'a2 functor0 -> 'a2 monad -> 'a2 monadIter -> (__ -> 'a1 -> ('a3, 'a2,
    __) Monads.stateT) -> ('a1, 'a4) itree -> ('a3, 'a2, 'a4) Monads.stateT **)

let interp_state fM mM iM h x x0 =
  interp (Monads.coq_Functor_stateT fM) (Monads.coq_Monad_stateT mM)
    (fun _ _ -> monadIter_stateT0 mM iM) h x x0

(** val pure_state : 'a2 -> 'a1 -> ('a2, 'a1 * 'a3) itree **)

let pure_state e s =
  lazy (Go (VisF (e, (fun x -> lazy (Go (RetF (s, (Obj.magic x))))))))

type ('k, 'v, 'x) mapE =
| Insert of 'k * 'v
| LookupDef of 'k
| Remove of 'k

(** val insert :
    'a2 -> (('a1, 'a2, __) mapE, 'a3) iFun -> 'a1 -> 'a2 -> ('a3, unit) itree **)

let insert _ h =
  embed
    (embeddable_forall (fun _ ->
      embeddable_forall (fun _ -> embeddable_itree h))) (fun x x0 -> Insert
    (x, x0))

(** val lookup_def :
    'a2 -> (('a1, 'a2, __) mapE, 'a3) iFun -> 'a1 -> ('a3, 'a2) itree **)

let lookup_def _ h =
  embed (embeddable_forall (fun _ -> embeddable_itree h)) (fun x -> LookupDef
    x)

(** val lookup_default : ('a1, 'a2, 'a3) map0 -> 'a1 -> 'a2 -> 'a3 -> 'a2 **)

let lookup_default h k d m =
  match h.lookup k m with
  | Some v' -> v'
  | None -> d

(** val handle_map :
    ('a1, 'a2, 'a3) map0 -> 'a2 -> ('a1, 'a2, 'a5) mapE -> 'a3 -> ('a4,
    'a3 * 'a5) itree **)

let handle_map m d e env0 =
  match e with
  | Insert (k, v) -> lazy (Go (RetF ((m.add0 k v env0), (Obj.magic ()))))
  | LookupDef k ->
    lazy (Go (RetF (env0,
      (lookup_default (Obj.magic m) k (Obj.magic d) env0))))
  | Remove k -> lazy (Go (RetF ((m.remove k env0), (Obj.magic ()))))

(** val interp_map :
    ('a1, 'a2, 'a3) map0 -> 'a2 -> ((('a1, 'a2, __) mapE, 'a4, __) sum1, 'a5)
    itree -> 'a3 -> ('a4, 'a3 * 'a5) itree **)

let interp_map m d x x0 =
  interp_state (Obj.magic functor_itree) (Obj.magic monad_itree)
    (Obj.magic (fun _ _ -> monadIter_itree))
    (case_ (Obj.magic __) (Obj.magic (fun _ _ _ x1 x2 _ -> case_sum0 x1 x2))
      __ __ __ (Obj.magic (fun _ -> handle_map m d))
      (Obj.magic (fun _ -> pure_state))) x x0

type ('k, 'v) alist = ('k * 'v) list

(** val alist_remove :
    'a1 relDec -> 'a1 -> ('a1, 'a2) alist -> ('a1, 'a2) alist **)

let alist_remove rD_K k m =
  filter (fun x -> negb (rel_dec rD_K k (fst x))) m

(** val alist_add :
    'a1 relDec -> 'a1 -> 'a2 -> ('a1, 'a2) alist -> ('a1, 'a2) alist **)

let alist_add rD_K k v m =
  (k, v) :: (alist_remove rD_K k m)

(** val alist_find : 'a1 relDec -> 'a1 -> ('a1, 'a2) alist -> 'a2 option **)

let rec alist_find rD_K k = function
| [] -> None
| p :: ms ->
  let (k', v) = p in
  if rel_dec rD_K k k' then Some v else alist_find rD_K k ms

(** val fold_alist :
    ('a1 -> 'a2 -> 'a3 -> 'a3) -> 'a3 -> ('a1, 'a2) alist -> 'a3 **)

let rec fold_alist f acc = function
| [] -> acc
| p :: m -> let (k, v) = p in let acc0 = f k v acc in fold_alist f acc0 m

(** val alist_union :
    'a1 relDec -> ('a1, 'a2) alist -> ('a1, 'a2) alist -> ('a1, 'a2) alist **)

let alist_union rD_K m1 m2 =
  fold_alist (alist_add rD_K) m2 m1

(** val map_alist : 'a1 relDec -> ('a1, 'a2, ('a1, 'a2) alist) map0 **)

let map_alist rD_K =
  { empty = []; add0 = (alist_add rD_K); remove = (alist_remove rD_K);
    lookup = (alist_find rD_K); union = (alist_union rD_K) }

type var = char list

type value = int

type expr =
| Var of var
| Lit of value
| Plus of expr * expr
| Minus of expr * expr
| Mult of expr * expr

type stmt =
| Assign of var * expr
| Seq of stmt * stmt
| If of expr * stmt * stmt
| While of expr * stmt
| Skip

module ImpNotations =
 struct
  (** val coq_Var_coerce : char list -> expr **)

  let coq_Var_coerce x =
    Var x

  (** val coq_Lit_coerce : int -> expr **)

  let coq_Lit_coerce x =
    Lit x
 end

type 'x impState =
| GetVar of var
| SetVar of var * value

(** val denote_expr :
    (__ impState, 'a1) iFun -> expr -> ('a1, value) itree **)

let rec denote_expr hasImpState = function
| Var v -> ITree.trigger (subevent hasImpState (GetVar v))
| Lit n0 -> ret (Obj.magic monad_itree) n0
| Plus (a, b) ->
  bind (Obj.magic monad_itree) (denote_expr hasImpState a) (fun l ->
    bind (Obj.magic monad_itree) (denote_expr hasImpState b) (fun r ->
      ret (Obj.magic monad_itree) (add l r)))
| Minus (a, b) ->
  bind (Obj.magic monad_itree) (denote_expr hasImpState a) (fun l ->
    bind (Obj.magic monad_itree) (denote_expr hasImpState b) (fun r ->
      ret (Obj.magic monad_itree) (sub l r)))
| Mult (a, b) ->
  bind (Obj.magic monad_itree) (denote_expr hasImpState a) (fun l ->
    bind (Obj.magic monad_itree) (denote_expr hasImpState b) (fun r ->
      ret (Obj.magic monad_itree) (mul l r)))

(** val while0 : ('a1, (unit, unit) sum) itree -> ('a1, unit) itree **)

let while0 step =
  iter1 (Obj.magic __) (fun _ _ ->
    iter_Kleisli (Obj.magic (fun _ _ -> monadIter_itree))) __ __ (fun _ ->
    Obj.magic step) ()

(** val is_true : value -> bool **)

let is_true v =
  if (=) v 0 then false else true

(** val denote_imp : (__ impState, 'a1) iFun -> stmt -> ('a1, unit) itree **)

let rec denote_imp hasImpState = function
| Assign (x, e) ->
  bind (Obj.magic monad_itree) (Obj.magic denote_expr hasImpState e)
    (fun v -> ITree.trigger (subevent hasImpState (SetVar (x, v))))
| Seq (a, b) ->
  bind (Obj.magic monad_itree) (denote_imp hasImpState a) (fun _ ->
    denote_imp hasImpState b)
| If (i, t, e) ->
  bind (Obj.magic monad_itree) (Obj.magic denote_expr hasImpState i)
    (fun v ->
    if is_true v then denote_imp hasImpState t else denote_imp hasImpState e)
| While (t, b) ->
  while0
    (bind (Obj.magic monad_itree) (Obj.magic denote_expr hasImpState t)
      (fun v ->
      if is_true v
      then bind (Obj.magic monad_itree) (Obj.magic denote_imp hasImpState b)
             (fun _ -> ret (Obj.magic monad_itree) (Inl ()))
      else ret (Obj.magic monad_itree) (Inr ())))
| Skip -> ret (Obj.magic monad_itree) ()

(** val fact : var -> var -> int -> stmt **)

let fact input output n0 =
  Seq ((Assign (input, (ImpNotations.coq_Lit_coerce n0))), (Seq ((Assign
    (output, (ImpNotations.coq_Lit_coerce (Pervasives.succ 0)))), (While
    ((ImpNotations.coq_Var_coerce input), (Seq ((Assign (output, (Mult
    ((ImpNotations.coq_Var_coerce output),
    (ImpNotations.coq_Var_coerce input))))), (Assign (input, (Minus
    ((ImpNotations.coq_Var_coerce input),
    (ImpNotations.coq_Lit_coerce (Pervasives.succ 0)))))))))))))

(** val relDec_string : char list relDec **)

let relDec_string =
  string_dec

(** val handle_ImpState :
    ((var, int, __) mapE, 'a1) iFun -> 'a2 impState -> ('a1, 'a2) itree **)

let handle_ImpState h = function
| GetVar x -> lookup_def (Obj.magic 0) (Obj.magic h) x
| SetVar (x, v) -> Obj.magic insert 0 h x v

type env = (var, value) alist

(** val interp_imp :
    ((__ impState, 'a1, __) sum1, 'a2) itree -> env -> ('a1, env * 'a2) itree **)

let interp_imp t =
  let t' =
    interp functor_itree monad_itree (Obj.magic (fun _ _ -> monadIter_itree))
      (bimap0 (Obj.magic __)
        (bimap_Coproduct (fun _ _ _ x x0 _ -> cat_Handler x x0)
          (Obj.magic __)
          (Obj.magic (fun _ _ _ x x0 _ -> case_sum1_Handler x x0))
          (Obj.magic (fun _ _ _ -> inl_sum1_Handler))
          (Obj.magic (fun _ _ _ -> inr_sum1_Handler))) __ __ __ __
        (Obj.magic (fun _ ->
          handle_ImpState (reSum_id (fun _ _ -> id_IFun) __)))
        (id_0 (fun _ _ -> id_Handler) __)) t
  in
  interp_map (map_alist relDec_string) 0 (Obj.magic t')

(** val eval_imp : stmt -> (__, env * unit) itree **)

let eval_imp s =
  interp_imp
    (denote_imp
      (reSum_inl (Obj.magic __)
        (Obj.magic (fun _ _ _ x x0 _ -> cat_IFun x x0)) (fun _ _ _ ->
        inl_sum1) __ __ __ (reSum_id (Obj.magic (fun _ _ -> id_IFun)) __)) s)
    (map_alist relDec_string).empty

(** val loopy : stmt **)

let loopy =
  While ((ImpNotations.coq_Lit_coerce (Pervasives.succ 0)), Skip)

(** val run : int -> (__, 'a1) itree -> 'a1 option **)

let rec run n0 t =
  (fun fO fS n -> if n=0 then fO () else fS (n-1))
    (fun _ -> None)
    (fun n1 ->
    match observe t with
    | RetF a -> Some a
    | TauF t0 -> run n1 t0
    | VisF (_, _) -> assert false (* absurd case *))
    n0

(** val run_ : n -> stmt -> env option **)

let run_ n0 s =
  option_map fst (run (N.to_nat n0) (eval_imp s))

(** val seq : (unit -> unit) -> (unit -> unit) -> (unit -> unit) **)

let seq = fun a b () -> a (); b ()

(** val print_binding : var -> int -> (unit -> unit) **)

let print_binding = fun v n () ->
     let to_string l =
       let l_ = ref l in
       String.init (List.length l) (fun _ ->
         match !l_ with
         | h :: t -> l_ := t; h
         | [] -> assert false) in
     let v = to_string v in
     print_string v;
     print_string ":=";
     print_int n;
     print_string ";"

(** val run_io : (unit -> unit) -> unit **)

let run_io = fun w -> w ()

(** val print_env : env -> (unit -> unit) **)

let rec print_env = function
| [] -> print_newline
| p :: e0 -> let (v, n0) = p in seq (print_binding v n0) (print_env e0)

(** val run' : n -> stmt -> (unit -> unit) **)

let run' n0 s =
  match run_ n0 s with
  | Some e -> print_env e
  | None -> print_newline

(** val test : unit **)

let test =
  run_io
    (seq (run' (Npos (XO (XO (XI (XO (XO (XI XH))))))) loopy)
      (run' (Npos (XO (XO (XO (XI (XO (XI (XI (XI (XI XH))))))))))
        (fact ('X'::[]) ('Y'::[]) (Pervasives.succ (Pervasives.succ
          (Pervasives.succ (Pervasives.succ (Pervasives.succ (Pervasives.succ
          (Pervasives.succ (Pervasives.succ (Pervasives.succ (Pervasives.succ
          0)))))))))))))
