
type __ = Obj.t

val negb : bool -> bool

val option_map : ('a1 -> 'a2) -> 'a1 option -> 'a2 option

type ('a, 'b) sum =
| Inl of 'a
| Inr of 'b

val fst : ('a1 * 'a2) -> 'a1

val snd : ('a1 * 'a2) -> 'a2



val add : int -> int -> int

val mul : int -> int -> int

val sub : int -> int -> int

type 'f functor0 =
  __ -> __ -> (__ -> __) -> 'f -> 'f
  (* singleton inductive, whose constructor was Build_Functor *)

val fmap : 'a1 functor0 -> ('a2 -> 'a3) -> 'a1 -> 'a1

type 'm monad = { ret : (__ -> __ -> 'm);
                  bind : (__ -> __ -> 'm -> (__ -> 'm) -> 'm) }

val ret : 'a1 monad -> 'a2 -> 'a1

val bind : 'a1 monad -> 'a1 -> ('a2 -> 'a1) -> 'a1

module Monads :
 sig
  type ('s, 'm, 'a) stateT = 's -> 'm

  val coq_Functor_stateT : 'a1 functor0 -> ('a2, 'a1, __) stateT functor0

  val coq_Monad_stateT : 'a1 monad -> ('a2, 'a1, __) stateT monad
 end

type 'm monadIter = __ -> __ -> (__ -> 'm) -> __ -> 'm

val iter : 'a1 monadIter -> ('a3 -> 'a1) -> 'a3 -> 'a1

val monadIter_stateT0 :
  'a1 monad -> 'a1 monadIter -> ('a4 -> ('a2, 'a1, ('a4, 'a3) sum)
  Monads.stateT) -> 'a4 -> ('a2, 'a1, 'a3) Monads.stateT

type ('obj, 'c) id_ = 'obj -> 'c

val id_0 : ('a1, 'a2) id_ -> 'a1 -> 'a2

type ('obj, 'c) cat = 'obj -> 'obj -> 'obj -> 'c -> 'c -> 'c

val cat0 : ('a1, 'a2) cat -> 'a1 -> 'a1 -> 'a1 -> 'a2 -> 'a2 -> 'a2

type ('obj, 'c) bimap = 'obj -> 'obj -> 'obj -> 'obj -> 'c -> 'c -> 'c

val bimap0 :
  ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) bimap -> 'a1 -> 'a1 -> 'a1 -> 'a1 -> 'a2
  -> 'a2 -> 'a2

type ('obj, 'c) case = 'obj -> 'obj -> 'obj -> 'c -> 'c -> 'c

val case_ :
  ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) case -> 'a1 -> 'a1 -> 'a1 -> 'a2 -> 'a2
  -> 'a2

type ('obj, 'c) inl = 'obj -> 'obj -> 'c

val inl_ : ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) inl -> 'a1 -> 'a1 -> 'a2

type ('obj, 'c) inr = 'obj -> 'obj -> 'c

val inr_ : ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) inr -> 'a1 -> 'a1 -> 'a2

val bimap_Coproduct :
  ('a1, 'a2) cat -> ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) case -> ('a1, 'a2) inl
  -> ('a1, 'a2) inr -> ('a1, 'a2) bimap

type ('obj, 'c) iter0 = 'obj -> 'obj -> 'c -> 'c

val iter1 :
  ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) iter0 -> 'a1 -> 'a1 -> 'a2 -> 'a2

type ('obj, 'c) reSum = 'c

val resum : 'a1 -> 'a1 -> ('a1, 'a2) reSum -> 'a2

val reSum_id : ('a1, 'a2) id_ -> 'a1 -> ('a1, 'a2) reSum

val reSum_inl :
  ('a1 -> 'a1 -> 'a1) -> ('a1, 'a2) cat -> ('a1, 'a2) inl -> 'a1 -> 'a1 ->
  'a1 -> ('a1, 'a2) reSum -> ('a1, 'a2) reSum

type ('e, 'r, 'itree) itreeF =
| RetF of 'r
| TauF of 'itree
| VisF of 'e * (__ -> 'itree)

type ('e, 'r) itree = ('e, 'r) __itree Lazy.t
and ('e, 'r) __itree =
| Go of ('e, 'r, ('e, 'r) itree) itreeF

val _observe : ('a1, 'a2) itree -> ('a1, 'a2, ('a1, 'a2) itree) itreeF

val observe : ('a1, 'a2) itree -> ('a1, 'a2, ('a1, 'a2) itree) itreeF

module ITree :
 sig
  val subst :
    ('a2 -> ('a1, 'a3) itree) -> ('a1, 'a2) itree -> ('a1, 'a3) itree

  val bind : ('a1, 'a2) itree -> ('a2 -> ('a1, 'a3) itree) -> ('a1, 'a3) itree

  val iter : ('a3 -> ('a1, ('a3, 'a2) sum) itree) -> 'a3 -> ('a1, 'a2) itree

  val map : ('a2 -> 'a3) -> ('a1, 'a2) itree -> ('a1, 'a3) itree

  val trigger : 'a1 -> ('a1, 'a2) itree
 end

val functor_itree : ('a1, __) itree functor0

val monad_itree : ('a1, __) itree monad

val monadIter_itree :
  ('a3 -> ('a1, ('a3, 'a2) sum) itree) -> 'a3 -> ('a1, 'a2) itree

type ('m, 'a, 'b) kleisli = 'a -> 'm

val iter_Kleisli :
  'a1 monadIter -> ('a1, 'a2, ('a2, 'a3) sum) kleisli -> ('a1, 'a2, 'a3)
  kleisli

module Nat :
 sig
 end

type ('e1, 'e2, 'x) sum1 =
| Inl1 of 'e1
| Inr1 of 'e2

type ('e, 'f) iFun = __ -> 'e -> 'f

val id_IFun : 'a1 -> 'a1

val cat_IFun : ('a1, 'a2) iFun -> ('a2, 'a3) iFun -> 'a1 -> 'a3

val case_sum1 :
  (__ -> 'a1 -> 'a3) -> (__ -> 'a2 -> 'a3) -> ('a1, 'a2, 'a4) sum1 -> 'a3

val case_sum0 :
  ('a1, 'a3) iFun -> ('a2, 'a3) iFun -> ('a1, 'a2, 'a4) sum1 -> 'a3

val inl_sum1 : 'a1 -> ('a1, 'a2, 'a3) sum1

val subevent : ('a1, 'a2) iFun -> 'a1 -> 'a2

type ('u, 'v) embeddable = 'u -> 'v

val embed : ('a1, 'a2) embeddable -> 'a1 -> 'a2

val embeddable_forall :
  ('a1 -> ('a2, 'a3) embeddable) -> ('a1 -> 'a2, 'a1 -> 'a3) embeddable

val embeddable_itree : ('a1, 'a2) iFun -> ('a1, ('a2, 'a3) itree) embeddable

val interp :
  'a2 functor0 -> 'a2 monad -> 'a2 monadIter -> (__ -> 'a1 -> 'a2) -> ('a1,
  'a3) itree -> 'a2

module Handler :
 sig
  val htrigger : (__ -> 'a1 -> 'a2) -> 'a1 -> ('a2, 'a3) itree

  val id_ : 'a1 -> ('a1, 'a2) itree

  val cat :
    (__ -> 'a1 -> ('a2, __) itree) -> (__ -> 'a2 -> ('a3, __) itree) -> 'a1
    -> ('a3, 'a4) itree

  val inl_ : 'a1 -> (('a1, 'a2, __) sum1, 'a3) itree

  val inr_ : 'a2 -> (('a1, 'a2, __) sum1, 'a3) itree

  val case_ :
    (__ -> 'a1 -> ('a3, __) itree) -> (__ -> 'a2 -> ('a3, __) itree) -> ('a1,
    'a2, 'a4) sum1 -> ('a3, 'a4) itree
 end

type ('e, 'f) handler = __ -> 'e -> ('f, __) itree

val id_Handler : 'a1 -> ('a1, 'a2) itree

val cat_Handler :
  ('a1, 'a2) handler -> ('a2, 'a3) handler -> 'a1 -> ('a3, 'a4) itree

val case_sum1_Handler :
  ('a1, 'a3) handler -> ('a2, 'a3) handler -> ('a1, 'a2, 'a4) sum1 -> ('a3,
  'a4) itree

val inl_sum1_Handler : 'a1 -> (('a1, 'a2, __) sum1, 'a3) itree

val inr_sum1_Handler : 'a2 -> (('a1, 'a2, __) sum1, 'a3) itree

val filter : ('a1 -> bool) -> 'a1 list -> 'a1 list

type positive =
| XI of positive
| XO of positive
| XH

type n =
| N0
| Npos of positive

module Pos :
 sig
  val iter_op : ('a1 -> 'a1 -> 'a1) -> positive -> 'a1 -> 'a1

  val to_nat : positive -> int
 end

module N :
 sig
  val to_nat : n -> int
 end

type 't relDec =
  't -> 't -> bool
  (* singleton inductive, whose constructor was Build_RelDec *)

val rel_dec : 'a1 relDec -> 'a1 -> 'a1 -> bool

val string_dec : char list -> char list -> bool

type ('k, 'v, 'map) map0 = { empty : 'map; add0 : ('k -> 'v -> 'map -> 'map);
                             remove : ('k -> 'map -> 'map);
                             lookup : ('k -> 'map -> 'v option);
                             union : ('map -> 'map -> 'map) }

val interp_state :
  'a2 functor0 -> 'a2 monad -> 'a2 monadIter -> (__ -> 'a1 -> ('a3, 'a2, __)
  Monads.stateT) -> ('a1, 'a4) itree -> ('a3, 'a2, 'a4) Monads.stateT

val pure_state : 'a2 -> 'a1 -> ('a2, 'a1 * 'a3) itree

type ('k, 'v, 'x) mapE =
| Insert of 'k * 'v
| LookupDef of 'k
| Remove of 'k

val insert :
  'a2 -> (('a1, 'a2, __) mapE, 'a3) iFun -> 'a1 -> 'a2 -> ('a3, unit) itree

val lookup_def :
  'a2 -> (('a1, 'a2, __) mapE, 'a3) iFun -> 'a1 -> ('a3, 'a2) itree

val lookup_default : ('a1, 'a2, 'a3) map0 -> 'a1 -> 'a2 -> 'a3 -> 'a2

val handle_map :
  ('a1, 'a2, 'a3) map0 -> 'a2 -> ('a1, 'a2, 'a5) mapE -> 'a3 -> ('a4,
  'a3 * 'a5) itree

val interp_map :
  ('a1, 'a2, 'a3) map0 -> 'a2 -> ((('a1, 'a2, __) mapE, 'a4, __) sum1, 'a5)
  itree -> 'a3 -> ('a4, 'a3 * 'a5) itree

type ('k, 'v) alist = ('k * 'v) list

val alist_remove : 'a1 relDec -> 'a1 -> ('a1, 'a2) alist -> ('a1, 'a2) alist

val alist_add :
  'a1 relDec -> 'a1 -> 'a2 -> ('a1, 'a2) alist -> ('a1, 'a2) alist

val alist_find : 'a1 relDec -> 'a1 -> ('a1, 'a2) alist -> 'a2 option

val fold_alist : ('a1 -> 'a2 -> 'a3 -> 'a3) -> 'a3 -> ('a1, 'a2) alist -> 'a3

val alist_union :
  'a1 relDec -> ('a1, 'a2) alist -> ('a1, 'a2) alist -> ('a1, 'a2) alist

val map_alist : 'a1 relDec -> ('a1, 'a2, ('a1, 'a2) alist) map0

type var = char list

type value = int

type expr =
| Var of var
| Lit of value
| Plus of expr * expr
| Minus of expr * expr
| Mult of expr * expr

type stmt =
| Assign of var * expr
| Seq of stmt * stmt
| If of expr * stmt * stmt
| While of expr * stmt
| Skip

module ImpNotations :
 sig
  val coq_Var_coerce : char list -> expr

  val coq_Lit_coerce : int -> expr
 end

type 'x impState =
| GetVar of var
| SetVar of var * value

val denote_expr : (__ impState, 'a1) iFun -> expr -> ('a1, value) itree

val while0 : ('a1, (unit, unit) sum) itree -> ('a1, unit) itree

val is_true : value -> bool

val denote_imp : (__ impState, 'a1) iFun -> stmt -> ('a1, unit) itree

val fact : var -> var -> int -> stmt

val relDec_string : char list relDec

val handle_ImpState :
  ((var, int, __) mapE, 'a1) iFun -> 'a2 impState -> ('a1, 'a2) itree

type env = (var, value) alist

val interp_imp :
  ((__ impState, 'a1, __) sum1, 'a2) itree -> env -> ('a1, env * 'a2) itree

val eval_imp : stmt -> (__, env * unit) itree

val loopy : stmt

val run : int -> (__, 'a1) itree -> 'a1 option

val run_ : n -> stmt -> env option

val seq : (unit -> unit) -> (unit -> unit) -> (unit -> unit)

val print_binding : var -> int -> (unit -> unit)

val run_io : (unit -> unit) -> unit

val print_env : env -> (unit -> unit)

val run' : n -> stmt -> (unit -> unit)

val test : unit
