# `super`-charging Object-Oriented Programming through Precise Typing of Open Recursion (Artifact)

## Getting Started

### Using the Docker Image

We have built a Docker image containing all necessary dependencies and exported it
into an archived file.
To use the image, one should first install Docker if it is not installed yet.
Then, one can launch a container using this image with the following command:

```
docker load -i superoop-docker.tar
docker run -it --rm superoop/superoop-docker:v1-amd64
```

The archived image in this artifact is compiled for the `amd64` platform.
Alternatively, we have prepared an image for the `arm64` platform and pushed it to [DockerHub](https://hub.docker.com/r/superoop/superoop-docker/tags).
If one wants to use the `arm64` image, the commands are:

```
docker pull superoop/superoop-docker:v1-arm64
docker run -it --rm superoop/superoop-docker:v1-arm64
```

The user will be attached to the shell of the container after the image gets
imported/pulled and the container is launched.
Please `cd` to `mlscript/` and launch the SBT shell by typing `sbt`.

### Setting up from Scratch

If one would like to run our implementation on their host system from scratch,
please follow the following steps:

1. Install NodeJS (for example `v16.16.0`) from https://nodejs.org/en/download/.
   Ensure your PATH is updated and the `node` command is available in the terminal.

2. Follow the Coursier installation instructions at https://get-coursier.io/docs/cli-installation.

3. Change your working directory to the root of this repository and
   launch the SBT shell by typing `sbt` in the terminal.

## Experimenting with MLscript

We provide two ways of experimenting with MLscript.

### Web demo

To run the web demo, compile the project with `mlscriptJS/fastOptJS`, 
then open the `local_testing.html` file in a browser.

### Test suite

To run the MLscript test suite, compile the project with `mlscriptJVM/test`.

The test output is inserted as comments beginning with `//│` in the test file,
immediately after each corresponding code block.
We recommend using an editor that automatically reloads open files on changes
so that the test results for each code block can be easily seen.

If there are any unstaged changes in any test file (those in `shared/src/test/diff`)
as determined by `git`,
only the corresponding files will be tested.
So one may make modifications to some test files and rerun the test command,
and only the modified tests will re-run.
